/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.google.common.collect.ImmutableList;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.compat.jei.BasinFermentingCategory;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineCategory;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineJeiRecipeType;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.recipes.RecipeRegistry;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.GhostIngredientHandler;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.equipment.blueprint.BlueprintScreen;
import com.simibubi.create.content.logistics.filter.AbstractFilterScreen;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerScreen;
import com.simibubi.create.content.trains.schedule.ScheduleScreen;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CDGJEI
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("createdieselgenerators", "jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();

    public ResourceLocation getPluginUid() {
        return ID;
    }

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory<BasinRecipe> basin_fermenting = this.builder(BasinRecipe.class).addTypedRecipes(RecipeRegistry.BASIN_FERMENTING).catalyst(() -> BlockRegistry.BASIN_LID.get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleItemIcon((ItemLike)AllBlocks.BASIN.get(), (ItemLike)BlockRegistry.BASIN_LID.get()).emptyBackground(177, 100).build("basin_fermenting", (CreateRecipeCategory.Factory<BasinRecipe>)((CreateRecipeCategory.Factory)BasinFermentingCategory::new));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DieselEngineCategory(registration.getJeiHelpers().getGuiHelper())});
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List fluids = FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_slow_strong")), (int)1000).getMatchingFluidStacks();
        if (((Boolean)ConfigRegistry.PLANTOIL_TAG.get()).booleanValue()) {
            fluids.addAll(FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:plantoil")), (int)1000).getMatchingFluidStacks());
        }
        if (!fluids.isEmpty()) {
            registration.addRecipes(DieselEngineJeiRecipeType.DIESEL_BURNING, (List)ImmutableList.of((Object)new DieselEngineJeiRecipeType(0, ((Double)ConfigRegistry.SLOW_SPEED.get()).floatValue(), ((Double)ConfigRegistry.STRONG_STRESS.get()).floatValue(), fluids)));
        }
        if (!(fluids = FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_slow_weak")), (int)1000).getMatchingFluidStacks()).isEmpty()) {
            registration.addRecipes(DieselEngineJeiRecipeType.DIESEL_BURNING, (List)ImmutableList.of((Object)new DieselEngineJeiRecipeType(1, ((Double)ConfigRegistry.SLOW_SPEED.get()).floatValue(), ((Double)ConfigRegistry.WEAK_STRESS.get()).floatValue(), fluids)));
        }
        fluids = FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_fast_strong")), (int)1000).getMatchingFluidStacks();
        if (((Boolean)ConfigRegistry.FUEL_TAG.get()).booleanValue()) {
            fluids.addAll(FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:fuel")), (int)1000).getMatchingFluidStacks());
        }
        if (((Boolean)ConfigRegistry.BIODIESEL_TAG.get()).booleanValue()) {
            fluids.addAll(FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:biodiesel")), (int)1000).getMatchingFluidStacks());
        }
        if (!fluids.isEmpty()) {
            registration.addRecipes(DieselEngineJeiRecipeType.DIESEL_BURNING, (List)ImmutableList.of((Object)new DieselEngineJeiRecipeType(2, ((Double)ConfigRegistry.FAST_SPEED.get()).floatValue(), ((Double)ConfigRegistry.STRONG_STRESS.get()).floatValue(), fluids)));
        }
        fluids = FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_fast_weak")), (int)1000).getMatchingFluidStacks();
        if (((Boolean)ConfigRegistry.ETHANOL_TAG.get()).booleanValue()) {
            fluids.addAll(FluidIngredient.fromTag((TagKey)AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:ethanol")), (int)1000).getMatchingFluidStacks());
        }
        if (!fluids.isEmpty()) {
            registration.addRecipes(DieselEngineJeiRecipeType.DIESEL_BURNING, (List)ImmutableList.of((Object)new DieselEngineJeiRecipeType(3, ((Double)ConfigRegistry.FAST_SPEED.get()).floatValue(), ((Double)ConfigRegistry.WEAK_STRESS.get()).floatValue(), fluids)));
        }
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
        registration.addRecipeCatalyst(BlockRegistry.DIESEL_ENGINE.asStack(), new RecipeType[]{DieselEngineJeiRecipeType.DIESEL_BURNING});
        registration.addRecipeCatalyst(BlockRegistry.MODULAR_DIESEL_ENGINE.asStack(), new RecipeType[]{DieselEngineJeiRecipeType.DIESEL_BURNING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSimiContainerScreen.class, (IGuiContainerHandler)new SlotMover());
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(BlueprintScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(LinkedControllerScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
        registration.addGhostIngredientHandler(ScheduleScreen.class, (IGhostIngredientHandler)new GhostIngredientHandler());
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)excluded.get()));
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe) || !CreateJEI.doOutputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : () -> Collections.emptyList();
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(new ResourceLocation("createdieselgenerators", name), this.recipeClass), (Component)CreateDieselGenerators.translate("createdieselgenerators.recipe." + name, new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            CDGJEI.this.allCategories.add(category);
            return category;
        }
    }
}

